// Options:
//   optAdditive : true, uses the diffuse texture and the fog is black. False uses the fog color and the fog is in alpha.

float4x4 matViewProjMatrix;
float4x4 matWorldMatrix;

struct VS_INPUT{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
	float4 color: COLOR0;
};


struct VS_OUTPUT{
	float4 position: POSITION;
	float2 tex: TEXCOORD0;
	float3 pos: TEXCOORD1;
	float4 color: COLOR0;
};


VS_OUTPUT vs_main(VS_INPUT input){
	VS_OUTPUT Out = (VS_OUTPUT)0;
	input.position = mul(input.position, matWorldMatrix);
	Out.position = mul(input.position, matViewProjMatrix);
	Out.pos = input.position;
	Out.tex = input.tex;
	Out.color = input.color;
	return Out;
}



sampler diffuseMap;
float3 viewPosition;
float4 fogColor;
float density;

float4 ps_main(float2 tex: TEXCOORD0, float3 pos: TEXCOORD1, float4 color: COLOR0):COLOR0{
	float dist = distance(pos, viewPosition);
	float fog = 1-1/pow(2.18, dist*dist*density*density);
	float4 result;
	if(optAdditive)
		result = tex2D(diffuseMap, tex)*(1-fog);
	else
		result = float4(fogColor.rgb, fog);
	return result;
}
